<?php
require 'config.php';
include 'navbar.php';

$id = $_GET['id'] ?? null;
if(!$id) die("لم يتم تحديد العميل.");

$stmt = $conn->prepare("SELECT * FROM customers WHERE id=?");
$stmt->execute([$id]);
$customer = $stmt->fetch(PDO::FETCH_ASSOC);
if(!$customer) die("العميل غير موجود.");

$message = '';
if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $name = $_POST['name'] ?? '';
    $balance = floatval($_POST['balance'] ?? 0);
    $address = $_POST['address'] ?? '';
    $phone = $_POST['phone'] ?? '';

    $stmt = $conn->prepare("UPDATE customers SET name=?, balance=?, address=?, phone=? WHERE id=?");
    $stmt->execute([$name,$balance,$address,$phone,$id]);
    $message = "✅ تم تحديث بيانات العميل.";
    $customer = ['name'=>$name,'balance'=>$balance,'address'=>$address,'phone'=>$phone];
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>تعديل عميل</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container mt-4">
<h2 class="mb-4 text-center">تعديل بيانات العميل</h2>

<?php if($message) echo "<div class='alert alert-success'>$message</div>"; ?>

<form method="post" class="w-50 mx-auto">
    <div class="mb-3">
        <label>الاسم</label>
        <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($customer['name']) ?>" required>
    </div>
    <div class="mb-3">
        <label>الرصيد</label>
        <input type="number" step="0.01" name="balance" class="form-control" value="<?= $customer['balance'] ?>">
    </div>
    <div class="mb-3">
        <label>العنوان</label>
        <input type="text" name="address" class="form-control" value="<?= htmlspecialchars($customer['address']) ?>">
    </div>
    <div class="mb-3">
        <label>الهاتف</label>
        <input type="text" name="phone" class="form-control" value="<?= htmlspecialchars($customer['phone']) ?>">
    </div>
    <button type="submit" class="btn btn-success">💾 حفظ التعديلات</button>
</form>
</body>
</html>
