<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require 'config.php';
require __DIR__ . '/vendor/autoload.php';

use Mpdf\Mpdf;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['manual_customer'])) {

    $customer_id = $_POST['manual_customer'];
    $product_ids = $_POST['product_id'] ?? [];
    $quantities  = $_POST['quantity'] ?? [];
    $prices      = $_POST['price'] ?? [];
    $units       = $_POST['unit'] ?? [];

    if (!$customer_id || empty($product_ids)) die("❌ يجب اختيار العميل وإضافة المنتجات");

    $stmt = $conn->prepare("SELECT * FROM customers WHERE id=?");
    $stmt->execute([$customer_id]);
    $customer = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$customer) die("❌ لم يتم العثور على العميل.");

    $tmpDir = __DIR__ . '/tmp';
    if (!file_exists($tmpDir)) mkdir($tmpDir, 0777, true);

    $mpdf = new Mpdf([
        'format'=>'A5',
        'orientation'=>'L', 
        'default_font'=>'dejavusans',
        'margin_top' => 30,
        'margin_bottom' => 15,
        'margin_left' => 15,
        'margin_right' => 15,
        'tempDir' => $tmpDir
    ]);

    $random_invoice = rand(1000,9999);
    $date = date('Y-m-d');

    if(!file_exists(__DIR__.'/invoices')) mkdir(__DIR__.'/invoices',0777,true);
    $pdf_file = __DIR__."/invoices/invoice_$random_invoice.pdf";

    $total_price = 0;
    $total_qty = 0;
    foreach($product_ids as $k=>$pid){
        $total_price += $quantities[$k]*$prices[$k];
        $total_qty += $quantities[$k];
    }

    // HTML الفاتورة
    $html = "
    <html lang='tr' dir='ltr'>
    <head>
    <meta charset='UTF-8'>
    <style>
        body { font-family: dejavusans; font-size: 12px; margin:0; padding:0; }
        .header { width:100%; overflow:hidden; margin-bottom:5px; }
        .header img { float:left; width:70px; height:auto; }
        .header .company-info { float:right; font-size:12px; line-height:1.1; text-align:right; }
        .customer-box { 
            border:1px solid #333; 
            padding:10px; 
            margin-bottom:12px; 
            font-size:14px; 
            line-height:1.6; 
            background:#f9f9f9; 
            text-align:center; 
            font-weight:bold;
        }
        table.products { border-collapse: collapse; width: 100%; font-size:12px; }
        table.products th, table.products td { border:1px solid #333; padding:6px; text-align:center; }
        table.products th { background-color:#f0f0f0; }
        .totals { text-align:right; margin-top:5px; font-weight:bold; font-size:13px; }
        .signature { margin-top:15px; text-align:left; font-size:13px; font-weight:bold; }
        h2 { text-align:center; margin:6px 0 10px 0; font-size:16px; }
    </style>
    </head>
    <body>

    <!-- رأس الصفحة -->
    <div class='header'>
        <img src='1.jpeg' style='width:90px; height:auto; display:block; float:left; margin:0; padding:0;'>
        <div class='company-info'>
            <strong>ALJAMEEL INTERNATIONAL GIDA SANAYI</strong><br>
            TEL: 05344438000 - 02124707700<br>
            ADRES: TURKEY- ISTANBUL-BASAKSEHIR<br>
            GIDA TOPTANCILER SETESI/3 ADA/2A/07_08
        </div>
        <div style='clear:both;'></div>
    </div>

    <!-- العنوان المركزي -->
    <h2>İRSALİYE</h2>

    <!-- معلومات العميل -->
    <div class='customer-box'>
        <div><strong>MÜŞTERİ:</strong> " . htmlspecialchars($customer['name']) . " &nbsp;&nbsp;|&nbsp;&nbsp;
        <strong>ADRES:</strong> " . htmlspecialchars($customer['address']) . "</div>
        <div>
            " . (!empty($customer['phone']) ? "<strong>TELEFON:</strong> " . htmlspecialchars($customer['phone']) . " &nbsp;&nbsp;|&nbsp;&nbsp;" : "") . "
            <strong>TARİH:</strong> $date &nbsp;&nbsp;|&nbsp;&nbsp;
            <strong>İRSALİYE NO:</strong> $random_invoice
        </div>
    </div>

    <!-- جدول المنتجات -->
    <table class='products'>
        <tr>
            <th>Ürün Adı</th>
            <th>Birim</th>
            <th>Miktar</th>
            <th>Birim Fiyat</th>
            <th>Toplam Tutar</th>
        </tr>";

    foreach($product_ids as $k=>$pid){
        $stmt = $conn->prepare("SELECT name FROM products WHERE id=?");
        $stmt->execute([$pid]);
        $p = $stmt->fetch(PDO::FETCH_ASSOC);
        $subtotal = $quantities[$k]*$prices[$k];
        $unit = $units[$k] ?? 'kg';
        $html .= "<tr>
            <td>{$p['name']}</td>
            <td>$unit</td>
            <td>{$quantities[$k]}</td>
            <td>{$prices[$k]}</td>
            <td>$subtotal</td>
        </tr>";
    }

    $html .= "
    </table>

    <p class='totals'>Toplam Miktar: $total_qty</p>
    <p class='totals'>Toplam Tutar: {$total_price} $</p>
    <p class='signature'>Teslim Alan: </p>

    </body>
    </html>";

    $mpdf->WriteHTML($html);
    $mpdf->Output($pdf_file,'F'); // حفظ PDF

    // === إرسال البريد ===
    $mail = new PHPMailer(true);
    try {
        $mail->isSMTP();
        $mail->Host = 'deltaweb.agency';
        $mail->SMTPAuth = true;
        $mail->Username = 'dd@deltaweb.agency';
        $mail->Password = '6dHQOAFf#xU&.ySi';
        $mail->SMTPSecure = 'ssl';
        $mail->Port = 465;

        $mail->setFrom('dd@deltaweb.agency', 'وصل تسليم');
        $mail->addAddress('aljameel@print.epsonconnect.com', $customer['name']);

        $mail->CharSet = 'UTF-8';
        $mail->isHTML(true);
        $mail->Subject = 'وصل تسليم';
        $mail->Body    = 'مرحبًا، تم إنشاء وصل تسليم جديد. يرجى الاطلاع على المرفقات.';
        $mail->addAttachment($pdf_file);

        $mail->send();
        echo "✅ تم إنشاء وإرسال وصل التسليم بنجاح!";
    } catch (Exception $e) {
        echo "❌ خطأ في إرسال البريد: " . $mail->ErrorInfo;
    }
}
