<?php
require 'config.php';
include 'navbar.php';

$message = '';
if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $name = $_POST['name'] ?? '';
    $balance = floatval($_POST['balance'] ?? 0);
    $address = $_POST['address'] ?? '';
    $phone = $_POST['phone'] ?? '';

    if($name){
        $stmt = $conn->prepare("INSERT INTO customers (name,balance,address,phone) VALUES (?,?,?,?)");
        $stmt->execute([$name,$balance,$address,$phone]);
        $message = "✅ تم إضافة العميل بنجاح.";
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>إضافة عميل</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container mt-4">
<h2 class="mb-4 text-center">إضافة عميل جديد</h2>

<?php if($message) echo "<div class='alert alert-success'>$message</div>"; ?>

<form method="post" class="w-50 mx-auto">
    <div class="mb-3">
        <label>الاسم</label>
        <input type="text" name="name" class="form-control" required>
    </div>
    <div class="mb-3">
        <label>الرصيد</label>
        <input type="number" step="0.01" name="balance" class="form-control" value="0">
    </div>
    <div class="mb-3">
        <label>العنوان</label>
        <input type="text" name="address" class="form-control">
    </div>
    <div class="mb-3">
        <label>الهاتف</label>
        <input type="text" name="phone" class="form-control">
    </div>
    <button type="submit" class="btn btn-success">💾 إضافة</button>
</form>
</body>
</html>
