<?php
include 'config.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// إضافة منتج جديد
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_product'])) {
    $name  = trim($_POST['name']);
    $price = floatval($_POST['unit_price']);
    $unit  = trim($_POST['unit']);

    if ($name !== '') {
        $stmt = $conn->prepare("INSERT INTO products (name, unit_price, unit) VALUES (?, ?, ?)");
        $stmt->execute([$name, $price, $unit]);
        $msg = "✅ تم إضافة المنتج بنجاح.";
    }
}

// حذف مادة
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $conn->prepare("DELETE FROM products WHERE id=?")->execute([$id]);
    $msg = "🗑️ تم حذف المادة.";
}

// حذف كل المواد
if (isset($_GET['delete_all'])) {
    $conn->exec("DELETE FROM products");
    $conn->exec("ALTER TABLE products AUTO_INCREMENT = 1");
    $msg = "🗑️ تم حذف جميع المواد.";
}

// جلب المواد
$rows = $conn->query("SELECT * FROM products ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>إدارة المواد</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container mt-4">

<!-- نفس القائمة العلوية للوحة التحكم -->
<nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4">
  <div class="container-fluid">
    <a class="navbar-brand" href="index.php">🏠 الرئيسية</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
        <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav">
        <li class="nav-item"><a class="nav-link" href="customers.php">العملاء</a></li>
        <li class="nav-item"><a class="nav-link" href="new_customer.php">إضافة عميل</a></li>
        <li class="nav-item"><a class="nav-link active" href="products.php">المنتجات</a></li>
        <li class="nav-item"><a class="nav-link" href="upload_customers.php">رفع عملاء</a></li>
        <li class="nav-item"><a class="nav-link" href="upload_products.php">رفع مواد</a></li>
                <li class="nav-item"><a class="nav-link" href="receivables.php">المستحقات والارصدة</a></li>
        <li class="nav-item"><a class="nav-link" href="update_credit.php
">رفع رصيد ائتماني</a></li>
      </ul>
    </div>
  </div>
</nav>

<h2 class="mb-4 text-center">📦 إدارة المواد</h2>

<?php if (isset($msg)): ?>
    <div class="alert alert-success text-center"><?= htmlspecialchars($msg) ?></div>
<?php endif; ?>

<!-- إضافة منتج جديد -->
<div class="card mb-4">
    <div class="card-header bg-primary text-white">➕ إضافة منتج جديد</div>
    <div class="card-body">
        <form method="post" class="row g-2">
            <div class="col-md-4"><input name="name" class="form-control" placeholder="اسم المنتج" required></div>
            <div class="col-md-3"><input name="unit_price" type="number" step="0.01" class="form-control" placeholder="السعر" required></div>
            <div class="col-md-3"><input name="unit" class="form-control" placeholder="الوحدة (اختياري)"></div>
            <div class="col-md-2"><button name="add_product" type="submit" class="btn btn-success w-100">إضافة</button></div>
        </form>
    </div>
</div>

<!-- جدول المواد -->
<div class="card">
    <div class="card-header bg-dark text-white">📋 قائمة المواد</div>
    <div class="card-body p-0">
        <table class="table table-bordered table-striped m-0 text-center">
            <thead class="table-light">
                <tr>
                    <th>#</th><th>الاسم</th><th>السعر</th><th>الوحدة</th><th>إجراءات</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($rows as $r): ?>
                    <tr>
                        <td><?= $r['id'] ?></td>
                        <td><?= htmlspecialchars($r['name']) ?></td>
                        <td><?= number_format($r['unit_price'], 2) ?></td>
                        <td><?= htmlspecialchars($r['unit']) ?></td>
                        <td>
                            <a href="edit_product.php?id=<?= $r['id'] ?>" class="btn btn-sm btn-info">✏️ تعديل</a>
                            <a href="?delete=<?= $r['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('هل تريد حذف هذه المادة؟')">🗑️ حذف</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
                <?php if (empty($rows)): ?>
                    <tr><td colspan="5">⚠️ لا توجد مواد بعد.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- حذف جميع المواد -->
<div class="mt-3 text-center">
    <a href="?delete_all=1" class="btn btn-danger" onclick="return confirm('هل أنت متأكد من حذف جميع المواد؟')">🗑️ حذف كل المواد</a>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
