<?php
require 'config.php';
require __DIR__ . '/vendor/autoload.php';
use Mpdf\Mpdf;

$message = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $text = $_POST['quick_text'] ?? '';

    // Regex لاستخراج الكمية والوحدة والسعر
    preg_match('/([\d.,]+)\s*(كغ|كجم|قطعة)?/u', $text, $qty_match);
    preg_match('/سعر\s*([\d.,]+)/u', $text, $price_match);

    $quantity = isset($qty_match[1]) ? floatval(str_replace(',', '.', $qty_match[1])) : 1;
    $unit = $qty_match[2] ?? '';
    $price = isset($price_match[1]) ? floatval(str_replace(',', '.', $price_match[1])) : 0;

    // استخراج الاسماء المتبقية
    $remaining = preg_replace('/([\d.,]+\s*(كغ|كجم|قطعة)?|سعر\s*[\d.,]+)/u', '', $text);
    $remaining = trim($remaining);

    // البحث عن العميل الأقرب
    $stmt = $conn->prepare("SELECT * FROM customers WHERE name LIKE ?");
    $stmt->execute(['%' . $remaining . '%']);
    $customer = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$customer) $message = "❌ لم يتم العثور على العميل. تأكد من كتابة الاسم.";
    else {
        // الباقي هو اسم المادة
        $product_name = trim(str_replace($customer['name'], '', $remaining));
        // إدخال المنتج مؤقتا في جدول المنتجات إذا لم يكن موجود
        $stmt = $conn->prepare("SELECT * FROM products WHERE name LIKE ?");
        $stmt->execute(['%' . $product_name . '%']);
        $product = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$product) {
            $stmt = $conn->prepare("INSERT INTO products (name, price, unit) VALUES (?, ?, ?)");
            $stmt->execute([$product_name, $price, $unit]);
            $product_id = $conn->lastInsertId();
        } else $product_id = $product['id'];

        // إنشاء الوصل مباشرة
        $stmt = $conn->prepare("INSERT INTO deliveries (customer_id, total) VALUES (?, ?)");
        $stmt->execute([$customer['id'], $price * $quantity]);
        $delivery_id = $conn->lastInsertId();

        $stmt = $conn->prepare("INSERT INTO delivery_items (delivery_id, product_id, quantity, price) VALUES (?, ?, ?, ?)");
        $stmt->execute([$delivery_id, $product_id, $quantity, $price]);

        // توليد PDF
        $mpdf = new Mpdf(['format'=>'A5-L']);
        $html = "
        <h2>وصل تسليم رقم #$delivery_id</h2>
        <p>العميل: {$customer['name']}</p>
        <table border='1' style='width:100%;border-collapse:collapse;'>
            <tr><th>المادة</th><th>الكمية</th><th>السعر</th><th>المجموع</th></tr>
            <tr>
                <td>$product_name</td>
                <td>$quantity $unit</td>
                <td>$price</td>
                <td>".($quantity*$price)."</td>
            </tr>
        </table>
        <h3>الإجمالي: ".($quantity*$price)." $</h3>
        <p>التوقيع: ________________</p>
        ";
        $filename = "delivery_quick_{$delivery_id}.pdf";
        $pdf_path = $PDF_DIR . "/" . $filename;
        $mpdf->WriteHTML($html);
        $mpdf->Output($pdf_path,'F');
        $mpdf->Output($filename,'I');
        exit;
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>وصل سريع</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container mt-4">
<h2>📄 إنشاء وصل سريع</h2>
<?php if($message) echo "<div class='alert alert-danger'>$message</div>"; ?>
<form method="post">
    <div class="mb-3">
        <textarea name="quick_text" class="form-control" rows="3" placeholder="مثال: 600 كغ جوز هند كامل اندونيسي سعر 4.400$ شركة الشرباتي" required></textarea>
    </div>
    <button class="btn btn-success">💾 إنشاء وصل سريع PDF</button>
</form>
</body>
</html>
