<?php
session_start();
require 'config.php';
if (empty($_SESSION['user'])) header('Location: login.php');

$id = $_GET['id'] ?? 0;
$stmt = $pdo->prepare("SELECT s.*, p.name FROM sales s JOIN products p ON p.id=s.product_id WHERE s.id=?");
$stmt->execute([$id]);
$sale = $stmt->fetch();

if (!$sale) die("⚠️ العملية غير موجودة");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_bags = $_POST['bags_sold'];
    $new_weight = $_POST['weight_sold'];
    $new_note = $_POST['note'];

    $pid = $sale['product_id'];
    $old_bags = $sale['bags_sold'];
    $old_weight = $sale['weight_sold'];

    // تعديل المخزون حسب الفرق
    $diff_bags = $old_bags - $new_bags;
    $diff_weight = $old_weight - $new_weight;

    $pdo->prepare("UPDATE stock SET bags_count = bags_count + ?, total_weight = total_weight + ? WHERE product_id=?")
        ->execute([$diff_bags, $diff_weight, $pid]);

    // تحديث عملية البيع
    $pdo->prepare("UPDATE sales SET bags_sold=?, weight_sold=?, note=? WHERE id=?")
        ->execute([$new_bags, $new_weight, $new_note, $id]);

    header("Location: sales.php?updated=1");
    exit;
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>✏️ تعديل عملية البيع</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background-color:#f8f9fa; }
.card { border-radius:15px; }
</style>
</head>
<body>

<?php include 'navbar.php'; ?>

<div class="container py-5">
  <div class="card p-4 shadow-sm">
    <h4 class="mb-3 text-center">✏️ تعديل عملية بيع</h4>

    <form method="post">
      <div class="mb-3">
        <label class="form-label">المادة</label>
        <input type="text" class="form-control" value="<?=$sale['name']?>" readonly>
      </div>

      <div class="mb-3">
        <label class="form-label">عدد الشوالات</label>
        <input type="number" name="bags_sold" class="form-control" value="<?=$sale['bags_sold']?>" required>
      </div>

      <div class="mb-3">
        <label class="form-label">الوزن الكلي (كغ)</label>
        <input type="number" step="0.01" name="weight_sold" class="form-control" value="<?=$sale['weight_sold']?>" required>
      </div>

      <div class="mb-3">
        <label class="form-label">ملاحظات</label>
        <textarea name="note" class="form-control" rows="3"><?=$sale['note']?></textarea>
      </div>

      <button class="btn btn-primary w-100">💾 حفظ التعديل</button>
      <a href="sales.php" class="btn btn-secondary mt-2 w-100">🔙 رجوع</a>
    </form>
  </div>
</div>

</body>
</html>
